#include "hprfgw_config.h"
#include "smac_pub_def.h"
#include "smac_mcu_hw_config.h"
#include "smac_mcu_spi_config.h"
#include "smac_MC13192_regs.h"
#include "smac_drivers.h"
#include "hprf_androidIntfc.h"
#include <linux/spi/spi.h>

/* TODO: HACK: Generalized dm_spi interface not implemented yet. */
/* TODO: Horribly ugly. See hprf_androidIntfc.c */
struct spi_device *hprf_spi;
int spi_imx_setup_xfer_once(struct spi_device *spi);
u32 crest_spi_write_read(struct spi_device *spi, u32 count, u8 *tx_buf, u8 *rx_buf);

void SMAC_SPIInit(void)
{
    spi_imx_setup_xfer_once(hprf_spi);
}

/* Should only be called with interrupts disabled. */
void SPIDrvWriteNoIrq(UINT8 addr, UINT16 content)
{
    /* Don't modify interrupts. */
    UINT8 content_byte[3];
    content_byte[0] = addr;
    content_byte[1] = (content>>8)&0xFF;
    content_byte[2] = (content)&0xFF;

    crest_spi_write_read(hprf_spi, 3, content_byte, content_byte);
}

/* Should only be called with interrupts disabled. */
UINT16 SPIDrvReadNoIrq(UINT8 addr)
{
    /* Don't modify interrupts. */
    u8 content_byte[3];
    u16 content;

    addr |= 0x80;
    content_byte[0] = addr;
    content_byte[1] = 0;        // For tx data
    content_byte[2] = 0;        // For tx data

    crest_spi_write_read(hprf_spi, 3, content_byte, content_byte);

    content = content_byte[2] | (content_byte[1] <<8);
    return content;
}

/*!
 * \brief SPIDrvWrite : Write 1 word to SPI
 *
 * \param u8Addr - SPI address
 * \param u16Content - Data to send
 *
 */
void SPIDrvWrite(UINT8 addr, UINT16 content)
{
    /*disable interrupts to avoid double access to zigbee spi*/
    MC13192DisableInterrupts();

	SPIDrvWriteNoIrq(addr, content);

    /*enable interrupts*/
    MC13192RestoreInterrupts();
}

/*!
 * \brief SPIDrvRead : Read 1 word from SPI
 *
 * \param u8Addr - SPI address
 *
 * \return u16Data -  u16Data[0] is the MSB, u16Data[1] is the LSB
 */
UINT16 SPIDrvRead(UINT8 addr)
{
    u16 content;

    /*disable interrupts to avoid double access to zigbee spi*/
    MC13192DisableInterrupts();

	content = SPIDrvReadNoIrq(addr);

    /*enable interrupts*/
    MC13192RestoreInterrupts();

    return content;
}

/*!
 * \brief RAMDrvWriteTx : Write a block of data to TX packet RAM, whichever is selected
 *
 * \param *psTxPkt - Packet to write
 *
 */
void RAMDrvWriteTx(tTxPacket *tx_pkt)
{
    UINT8 tx_buf[132], u8addr;      //SMAC_PAYLOAD_MAXSIZE 127 +  a few extra bytes
    UINT32 dwTxBytes, dwBufIndex;
    UINT16 tmp;

    /*Prepare the packet length by adding 2 to the total value*/
    /*for MDR purposes*/
    tmp = SPIDrvRead(TX_PKT_LEN);
    // MNT - 4/27/2007 - The Header will now be put in by the MAC layer above this
    // We only add for the CRC
    SPIDrvWrite(TX_PKT_LEN,((tmp & 0xFF80) | (tx_pkt->u8DataLength + 2) ));

    // Now disable interrupt
    MC13192DisableInterrupts();

    dwBufIndex = 1;     // Start filling from index 1, Index 0 is for address

    // Fill up the buffer
    for (dwTxBytes = 0; dwTxBytes <= tx_pkt->u8DataLength;)
    {
        tx_buf[dwBufIndex] = tx_pkt->pu8Data[dwTxBytes+1];
        tx_buf[dwBufIndex+1] = tx_pkt->pu8Data[dwTxBytes];
        dwTxBytes = dwTxBytes + 2;
        dwBufIndex = dwBufIndex + 2;
    }

    u8addr = TX_PKT;    // address of TX_PKT RAM
    tx_buf[0] = u8addr; // Fill the address in index 0

    // Include address also in the count
    crest_spi_write_read(hprf_spi, (dwTxBytes + 1), tx_buf, tx_buf);

    // Restore interrupts
    MC13192RestoreInterrupts();
}

/*!
 * \brief RAMDrvReadRx : Read a block of data from RX packet RAM, whichever is selected
 *
 * \param *psRxPkt - Packet received
 *
 * \return u8Status
 */
UINT8 RAMDrvReadRx(tRxPacket *rx_pkt)
{
    UINT32 i, ReadBytes;
    UINT8 addr, readbuffer[132 + 8];    // Keep extra 4 bytes + 8 for safety just in case!
    UINT8 *ptrReadBuf;                  // Pointer to read buffer

    // Clear the read buffer
    memset(readbuffer, 0, sizeof (readbuffer));

    // We are going to discard first 2 bytes, so subtract 2
    rx_pkt->u8DataLength  = rx_pkt->u8DataLength  - 2;

    /*disable interrupts to avoid double access to zigbee spi*/
    MC13192DisableInterrupts();

    addr = (RX_PKT | 0x80); // Fill the address and READ bit in the first byte to Tx

    // Adjust the no of bytes to read to even.
    ReadBytes = rx_pkt->u8DataLength;
    if ((ReadBytes % 2))
        ReadBytes++;
    else
        ReadBytes += 2;

    readbuffer[0] = addr;

    // Include address, 2 CRCs also in the count
    crest_spi_write_read(hprf_spi, (ReadBytes + 1 + 2), readbuffer, readbuffer);

    // We have to discard first three bytes what we read, address byte write + 2 CRC bytes
    // So we use a pointer to read buffer.
    ptrReadBuf = &readbuffer[3];

    // Now copy data from buffer to actual buffer by swapping alternate bytes
    // The MC13192 sends bytes in reverse order - BYTE2 first, BYTE1 second.
    for (i = 0; i <= rx_pkt->u8DataLength;)
    {
        if(i+1 == rx_pkt->u8DataLength )
        {
            /*do nothing garbage byte*/
            /*Last Odd byte*/
        }
        else
        {
            rx_pkt->pu8Data[i+1] = ptrReadBuf[i];
        }
        rx_pkt->pu8Data[i] = ptrReadBuf[i+1];
        i = i + 2;
    }
    /*enable interrupts*/
    MC13192RestoreInterrupts();

    return SMAC_SUCCESS;
}

/* This function is not used. Can be used for test purpose */
/*!
 * \brief RAMDrvReadRx : Read a block of data from RX packet RAM, whichever is selected
 *
 * \param *psRxPkt - Packet received
 *
 * \return u8Status
 */
UINT8 RAMDrvReadTx(UINT8 *tx_pkt, UINT16 numbytes)
{
	return 0;
}


